'use client';
import { useLocale } from 'next-intl';
import { motion, Transition } from "motion/react"

interface LocalizedText {
  ar: string;
  en: string;
}

interface PageHeaderItem {
  id: number;
  title: LocalizedText;
  description: LocalizedText;
}

export default function PageItem(props: PageHeaderItem) {
  const { id, title, description } = props;
  const locale = useLocale() as 'ar' | 'en';
  
  const springTransition: Transition = {
    duration: 0.6,
    delay: 0.3,
    ease: [0, 0.71, 0.2, 1.01],
  };

  return (
      <motion.div
        key={id}
        className="w-full flex flex-col justify-start items-start gap-2"
        initial={{ opacity: 0, y: 10 }}
        whileInView={{ opacity: 1, y: 0 }}
        viewport={{ once: false, amount: 0.2 }}
        transition={springTransition}
      >
        <div className="font-bold font-almarai">
          {title[locale]}
        </div>
        <div className="font-light text-gray-600 font-almarai mb-10" dangerouslySetInnerHTML={{ __html: description[locale] }} />
      </motion.div>
  )
}